import type { Schema } from "../resource"
// @ts-ignore
import { env } from "$amplify/env/delete-user"
import {
  CognitoIdentityProviderClient,
  AdminDeleteUserCommand,
  AdminGetUserCommand,
} from "@aws-sdk/client-cognito-identity-provider"
import { DynamoDBClient } from "@aws-sdk/client-dynamodb";
import {
  DynamoDBDocumentClient,
  DeleteCommand
} from "@aws-sdk/lib-dynamodb";
import { getUserIdFromAttributes } from "../../lib/user";

type Handler = Schema["inviteNewUser"]["functionHandler"]
const client = new CognitoIdentityProviderClient()

type INTERNAL__UserMetadataStructure = Schema["UsersMetadata"]["deleteType"]

const dynamoClient = new DynamoDBClient({});

const dynamo = DynamoDBDocumentClient.from(dynamoClient);

export const handler: Handler = async (event) => {
  const { email } = event.arguments

  const userPoolId = getUserpoolFromLambdaEnvironment(env)
  const getUserCommand = new AdminGetUserCommand({
    Username: email,
    UserPoolId: userPoolId,
  })

  const userResult = await client.send(getUserCommand)
  const id = getUserIdFromAttributes(userResult.UserAttributes)
  if (!id) {
    return {
      statusCode: 404,
      error: JSON.stringify({
        message: `Unable to find expected user id for newly created user '${email}'`,
        $metadata: userResult
      })
    }
  }

  try {
    const deleteCommand = new AdminDeleteUserCommand({
      Username: email,
      UserPoolId: userPoolId,
    })

    const [response] = await Promise.all([
      client.send(deleteCommand),
      dynamo.send(
        new DeleteCommand({
          TableName: env.BACKEND_USER_METADATA_DYNAMODB_TABLENAME,
          Key: {
            userid: id,
          } satisfies INTERNAL__UserMetadataStructure
        })
      ),
    ])

    return response
  } catch (e) {
    return {
      statusCode: 500,
      error: e,
    }
  }
}

function INTERNAL__generateEnvironmentUserpoolKey() {
  return `${env.BACKEND_AWS_COGNITO_RESOURCE_NAME_PREFIX.toUpperCase()}_USERPOOL_ID`
}

export function getUserpoolFromLambdaEnvironment(lambdaEnvironment: Record<string, string>) {
  const key = INTERNAL__generateEnvironmentUserpoolKey()
  return lambdaEnvironment[key]
}
